﻿/*	VERSION:	1.3
1.3		Better compatibility with certain components by prioritizing clip.width  (specifically the FileBrowser component)
1.2		Measures movieClip size based solely on the result of getBounds(),  which allows correct hit-detection with scaled movieClips
1.1		Now uses .getBounds() for compatibility with movieClips whose origin is not located at their top-left corner.

USAGE:
	#include "functions/hitClip.as"
	react.to("onDropFiles").from(dropFileEvents).then = function( evt )	{
		if(  !hitClip( {x:_root._xmouse,y:_root._ymouse}, bg )  )		return;
		
		if( !hitClip( evt.mouse, bg ) )		return;
		// do stuff
	}// onDropFiles()
*/
function getClipRect( clip, relativeTo ){
	var relativeTo = relativeTo || _root;
	// top-left corner
	if( clip.width !== undefined ){
		var ww = clip.width;
		var hh = clip.height;
		var xx = (clip.x !== undefined) ? clip.x : clip._x;
		var yy = (clip.y !== undefined) ? clip.y : clip._y;
		var topLeft = new flash.geom.Point(xx,yy);
		// convert  topLeft + size  =>  Rectangle
		var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
		return output_rect;
	}
	else if( clip.getBounds ){
		var bounds = clip.getBounds( relativeTo );
		var ww = bounds.xMax - bounds.xMin;
		var hh = bounds.yMax - bounds.yMin;
		var output_rect = new flash.geom.Rectangle( bounds.xMin, bounds.yMin, ww, hh );
		return output_rect;
		// var topLeft = new flash.geom.Point( bounds.xMin, bounds.yMin );
		// var topLeft = bounds.topLeft;
		// convert  topLeft + size  =>  Rectangle
		// var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
		// return output_rect;
	}
	else{
		// size
		var ww = clip._width;
		var hh = clip._height;
		var xx = (clip.x !== undefined) ? clip.x : clip._x;
		var yy = (clip.y !== undefined) ? clip.y : clip._y;
		var topLeft = new flash.geom.Point(xx,yy);
		// convert  topLeft + size  =>  Rectangle
		var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
		return output_rect;
	}
}// getClipRect()


function hitClip( coords_p, clip ){
	var rect = getClipRect( clip, _root );
	var output = rect.containsPoint( coords_p );
	//mdm.Exception.DebugWindow.trace("hitting "+clip._name+": "+output+"   rect: "+rect);
	return output;
}// hitClip()